<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

class CBlogWidgetTopicList extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "2",
		"name"	=> "Topic List",
		"module"	=> array(
			"name"	=> "",
			"id"	=> "",
			"type"	=> "",
		)
	);

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $_SESS;

		$cnt = max(1, $widget["settings"]["set_items"]);

		switch ($widget["settings"]["set_type"]) {
			//latest
			case "1":
				$order = "item_date DESC";
			break;

			//most viewed
			case "2":
				$order = "item_set_views DESC , item_date DESC";
			break;
		}
		

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:blog_topics']} as t , 
				{$this->tables['plugin:blog_topics_lang']} as l ,
				{$this->tables['plugin:blog_authors']} as a , 
				{$this->tables['plugin:blog_authors_lang']} as al 

			WHERE 
				t.item_author=a.author_id AND 
				a.author_id = al.author_id AND 
				al.lang_id = l.lang_id AND 
				t.module_id = {$widget[mod_id]} AND 
				l.lang_id={$widget[lang_id]} AND 
				t.item_id=l.item_id AND
				t.item_status = 1 AND 
				t.item_date <= " . time() . " 
				" . ( $_SESS["client"] ? "" : " AND item_protect=0 ") . "

			ORDER BY {$order}
			LIMIT $cnt
			"
		);

		if (is_array($items)) {

			global $base;


			$elements = explode("," , $widget["settings"]["set_elements"]);

			foreach ($items as $key => $val) {

				$items[$key]["_title"] = $items[$key]["_image"] = $items[$key]["_date"]= $items[$key]["_author"] = $items[$key]["_comments"] = "";

				$items[$key]["link"] = $widget["link"] . $val["item_url"] . "/" . $val["item_id"] ;


				if (in_array("image" , $elements)) {
					$val["image"] = $this->plugins["media"]->GetThumb($val["item_id"] , $val["module_id"] , array("path" => "upload/blog"));
					$items[$key]["_image"] = $this->tpl->blockReplace($val["image"] ? "Photo" : "NoPhoto" , $val);
				}

				if (in_array("title" , $elements)) {
					$items[$key]["_title"] = $this->tpl->blockReplace(
						"Title",
						$val
					);
				}


				if (in_array("brief" , $elements)) {
					$items[$key]["item_brief"] = $val["item_brief"] = strip_tags($val["item_brief"]);

					if (strlen($val["item_brief"]) > $widget["settings"]["set_chars"]) {
						$items[$key]["item_brief"] = substr($val["item_brief"] , 0, $widget["settings"]["set_chars"]) . "[...]"; 
					}
				}
				
				if (in_array("author" , $elements)) {
					$val["author_link"] = $widget["link"] . "authors/" . $val["author_url"] . "/" ;
					$items[$key]["_author"] = $this->tpl->blockReplace($val["author_details"] ? "AuthorLink" : "Author" , $val);
				}

				if (in_array("comments" , $elements)) {

					$val["item_stats_comments"] = $this->plugins["comments"]->CommentsCount(
						$widget["mod_settings"]["set_comments_details"],
						$items[$key]["link"],
						$items[$key]["item_stats_comments"]
					);

					$items[$key]["_comments"] = $this->tpl->blockReplace(
						"Comments",
						$val
					);
				}

				if (in_array("date" , $elements)) {
					$items[$key]["date"]	= CDate::ToStr("j M Y" , $val["item_date"]);
					$items[$key]["time"]	= CDate::ToStr("g:i a" , $val["item_date"]);

					$items[$key]["_date"] = $this->tpl->blockreplace(
						"Date",
						$items[$key]
					);
				}





			}
			

			return $this->tpl->blockReplace(
				"Main" , 
				array(
					"widget_title"	=> $widget["widget_name"],
					"news"			=> $base->html->table(
						$this->tpl, 
						"" , 
						$items
					)
				),
				$widget["mod_settings"]
			);
		}

	}
	
}


?>